module My_RPG



  class My_Command_Propriete_Carte < My_Command_2


    #
    CODE = CODE_PROPRIETE_MAP

    def initialize(file_name)
      super()
      @file_name = file_name
    end




    def self.from_rmxp(com)
      #p com
      #getz
      case com.parameters[0]
      when 0 # Panorama
        return My_Command_Propriete_Panorama.from_rmxp(com)
      when 1 # Fog
        return My_Command_Propriete_Fog.from_rmxp(com)
      when 2 # Battleback
        return My_Command_Propriete_Battleback.from_rmxp(com)
      end
      
    end


    
  end

  

  class My_Command_Propriete_Panorama < My_Command_Propriete_Carte

    attr_accessor :panorama

    def initialize(file_name, hue)
      super(file_name)
      @hue = hue
      @dir = D_PANORAMAS
    end

    def panorama
      return @file_name
    end

    def self.from_rmxp(com)
      my = self.new(com.parameters[1], com.parameters[2])

      return my
    end

    
    def to_rmxp_contenu
      return [0, @file_name, @hue]
    end





  end


  

  class My_Command_Propriete_Fog < My_Command_Propriete_Carte

    attr_accessor :opacity
    attr_accessor :transparency
    attr_accessor :stretch
    attr_accessor :axe_x
    attr_accessor :axe_y




    def initialize(filename, hue, opacity, transparency, stretch, axe_x, axe_y)
      super(filename)
      @hue = hue
      @opacity = opacity
      @transparency  = transparency
      @stretch = stretch
      @axe_x = axe_x
      @axe_y = axe_y
      @dir = D_FOGS
      @fog = ""
    end


    def fog
      return @file_name
    end


    def to_rmxp_contenu
      return [1, @file_name, @hue, @opacity, @transparency, @stretch, @axe_x, @axe_y]
    end

    def self.from_rmxp(com)
      #p com.parameters[1..7]
      return self.new(*com.parameters[1..7])
    end

  end

  

  class My_Command_Propriete_Battleback < My_Command_Propriete_Carte

    attr_accessor :battleback

    def initialize(file_name)
      super(file_name)
      @dir = D_BATTLEBACKS
      @battleback = ""

    end


    def battleback
      return @file_name
    end


    def self.from_rmxp(com)
      return self.new(com.parameters[1])
    end

    def to_rmxp_contenu
      return [2, @file_name]
    end


  end


end